<?php

use Spatie\LaravelSettings\Migrations\SettingsMigration;

class AddPasswordGeneratorToolSettings extends SettingsMigration
{
    public function up(): void
    {
        $this->migrator->add('tool-password-generator.enabled', TRUE);
        $this->migrator->add('tool-password-generator.title', 'Password Generator');
        $this->migrator->add('tool-password-generator.summary', 'Generate secure random passwords.');
        $this->migrator->add('tool-password-generator.description', 'Password Generator allows you to generate passwords based on many different settings. The passwords generated by Password Generator are randomized. These passwords are also secure as they are not sent over the internet and only exist on the client\'s machine.');
    
        $this->migrator->add('tool-slugs.PasswordGenerator', 'password-generator');
    }

    public function down() : void
    {
        $this->migrator->delete('tool-password-generator.enabled');
        $this->migrator->delete('tool-password-generator.title');
        $this->migrator->delete('tool-password-generator.summary');
        $this->migrator->delete('tool-password-generator.description');

        $this->migrator->delete('tool-slugs.PasswordGenerator');
    }
}
